/**
* \file: errmem_debug.h
*
* This file keeps definitions for debug purpose.
* 
* \component: errmemd
*
* \author: Kai Tomerius (ktomerius@de.adit-jv.com)
*          Markus Kretschmann (mkretschmann@de.adit-jv.com)
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
* <history item>
*/

#ifdef _ARCH_x86_

// run on host
#include <stdio.h>

// fake the kernel environment
#include "kernel.h"
#include "errmem_driver.h"

extern int fds;
extern struct file files[2];

extern char _errmem[1<<20];
extern unsigned errmem_size;
extern int errmem_initialized;

#define init_errmem()							\
	({								\
		if (!errmem_initialized++)				\
			llrb = llrb_init_mem(_errmem, errmem_size, 0);	\
		0;							\
	})

#define exit_errmem()				\
	({					\
		0;				\
	})

#define _open(p, f) (init_errmem(), __open(p, f))
#define _ioctl  __ioctl
#define _select __select
#define _read   __read
#define _write  __write
#define _close  __close

#else // ifdef _ARCH_x86_

#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/select.h>

#define init_errmem()
#define exit_errmem()

#define _open  open
#define _ioctl ioctl
#define _select select
#define _read  read
#define _write write
#define _close close

#endif // ifdef _ARCH_x86_
